/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.toolkit.utils.IVWAppLauncher;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWOpenItemInfo;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWUrlEncodingUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Container;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class VWOpenItem {
    private static final int PREFS_CURRENT = 0;
    private static final int PREFS_USER = 1;
    private static final int PREFS_REGION = 2;
    private static final int PREFS_SYSTEM = 3;
    private static final int PREFS_COUNT = 4;
    private VWSessionInfo m_sessionInfo = null;
    private Integer[] m_webAppPrefs = null;
    private Hashtable m_settings = null;

    public VWOpenItem(VWSession vwSession, Container parentContainer, JApplet parentApplet) {
        try {
            this.m_sessionInfo = new VWSessionInfo(parentContainer, parentApplet, vwSession);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWOpenItem(VWSessionInfo vwSessionInfo) {
        try {
            this.m_sessionInfo = new VWSessionInfo(vwSessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openStepProcessor(String queueName, String wob, String stepName, VWStepProcessorInfo stepInfo) {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            if (queueName == null) {
                JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_missingQueueName, VWResource.s_unableToOpenStepProcessor, 0);
                return;
            }
            if (wob == null) {
                JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_missingWOBNumber, VWResource.s_unableToOpenStepProcessor, 0);
                return;
            }
            if (stepName == null) {
                stepName = "";
            }
            if (!this.verifyProcessorInfo(stepInfo) && (stepInfo = this.fetchDefaultStepProcessor()) != null) {
                JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_stepProcessorInformationInvalid, VWResource.s_usingDefaultStepProcessor, 2);
            }
            this.m_sessionInfo.setRuntimeInfo(queueName, wob);
            this.m_sessionInfo.setRequestedSize(725, 600);
            if (stepInfo != null) {
                this.m_sessionInfo.setRequestedSize(stepInfo.getWidth(), stepInfo.getHeight());
                String appName = stepInfo.getApplicationName();
                if (stepInfo.getAppType() == 64 && appName != null && appName.length() > 0 && this.launchApplication(stepInfo.getApplicationName(), false, null)) {
                    return;
                }
                VWOpenItemInfo itemInfo = this.getOpenItemInfo(stepInfo, 1);
                if (itemInfo != null) {
                    Object[] parameters = new Object[5];
                    parameters[0] = itemInfo.getBaseURL();
                    parameters[1] = stepInfo.getLocation(itemInfo.getWebAppId());
                    switch (itemInfo.getWebAppId()) {
                        case 2: 
                        case 3: 
                        case 100: {
                            parameters[2] = URLEncoder.encode(queueName);
                            parameters[3] = URLEncoder.encode(wob);
                            parameters[4] = URLEncoder.encode(stepName);
                            break;
                        }
                        default: {
                            parameters[2] = VWUrlEncodingUtils.encodeLabel(queueName);
                            parameters[3] = VWUrlEncodingUtils.encodeLabel(wob);
                            parameters[4] = VWUrlEncodingUtils.encodeLabel(stepName);
                        }
                    }
                    String pageURL = MessageFormat.format(itemInfo.getSpUrlTemplate(), parameters);
                    if (this.displayURL(pageURL)) {
                        return;
                    }
                }
            }
            JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_stepProcessorAndDefaultStepProcessorInformationInvalid, VWResource.s_usingInstalledStepProcessor, 2);
            this.launchApplication("filenet.vw.apps.steps.tabbed.VWTabbedStepApplication", false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openLaunchStepProcessor(VWStepProcessorInfo launchStepInfo, String docId, String subject, String attachmentId) {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            if (docId == null) {
                JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_missingWorkClassID, VWResource.s_unableToOpenLaunchStepProcessor, 0);
                return;
            }
            if (subject == null) {
                subject = "";
            }
            if (attachmentId == null) {
                attachmentId = "";
            }
            if (!this.verifyProcessorInfo(launchStepInfo) && (launchStepInfo = this.fetchDefaultLaunchStepProcessor()) != null) {
                JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_launchStepProcessorInformationInvalid, VWResource.s_usingDefaultLaunchStepProcessor, 2);
            }
            this.m_sessionInfo.setLaunchInfo(docId, attachmentId, subject);
            this.m_sessionInfo.setRequestedSize(500, 600);
            if (launchStepInfo != null) {
                this.m_sessionInfo.setRequestedSize(launchStepInfo.getWidth(), launchStepInfo.getHeight());
                String appName = launchStepInfo.getApplicationName();
                if (launchStepInfo.getAppType() == 64 && appName != null && appName.length() > 0 && this.launchApplication(launchStepInfo.getApplicationName(), false, null)) {
                    return;
                }
                VWOpenItemInfo itemInfo = this.getOpenItemInfo(launchStepInfo, 0);
                if (itemInfo != null) {
                    Object[] parameters = new Object[6];
                    parameters[0] = itemInfo.getBaseURL();
                    parameters[1] = launchStepInfo.getLocation(itemInfo.getWebAppId());
                    switch (itemInfo.getWebAppId()) {
                        case 2: 
                        case 3: 
                        case 100: {
                            parameters[2] = URLEncoder.encode(docId);
                            parameters[3] = URLEncoder.encode(subject);
                            parameters[4] = URLEncoder.encode(attachmentId);
                            break;
                        }
                        default: {
                            parameters[2] = VWUrlEncodingUtils.encodeLabel(docId);
                            parameters[3] = VWUrlEncodingUtils.encodeLabel(subject);
                            parameters[4] = VWUrlEncodingUtils.encodeLabel(attachmentId);
                        }
                    }
                    parameters[5] = "";
                    String pageURL = MessageFormat.format(itemInfo.getLspUrlTemplate(), parameters);
                    if (this.displayURL(pageURL)) {
                        return;
                    }
                }
            }
            JOptionPane.showMessageDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_launchStepProcessorAndDefaultLaunchStepProcessorInformationInvalid, VWResource.s_usingInstalledLaunchStepProcessor, 2);
            this.launchApplication("filenet.vw.apps.launchers.tabbed.VWTabbedLaunchStepApplication", false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openStatusTracker(String queueName, String wob) {
        this.openStatusTracker(queueName, wob, 0);
    }

    public void openStatusTracker(String queueName, String wob, int trackerMode) {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            this.m_sessionInfo.setRuntimeInfo(queueName, wob);
            this.m_sessionInfo.setTrackerMode(trackerMode);
            this.launchApplication("filenet.vw.apps.tracker.VWTrackerApplication", false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openPWM() {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            this.launchApplication("filenet.vw.apps.manager.VWWorkflowManagerApplication", true, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openProcessAdministrator() {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            this.launchApplication("filenet.vw.apps.admin.VWAdminApplication", true, VWResource.s_pwAdministratorGroup);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openSimulationConsole() {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            this.launchApplication("filenet.sim.apps.console.VWSIMConsoleApplication", true, VWSIMResource.s_poConsoleGroup);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean displayURL(String pageURL) {
        try {
            if (this.m_sessionInfo == null) {
                return false;
            }
            JApplet parentApplet = this.m_sessionInfo.getParentApplet();
            if (parentApplet != null && parentApplet.isActive()) {
                parentApplet.getAppletContext().showDocument(new URL(pageURL), "_blank");
                return true;
            }
            String command = null;
            if (OperatingSystem.isWindows()) {
                command = "cmd /c start";
                pageURL = pageURL.replaceAll("&", "\"&\"");
            } else {
                command = "mozilla";
            }
            pageURL = pageURL.replaceAll(" ", "%20");
            Runtime.getRuntime().exec(command + " " + pageURL);
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public void releaseReferences() {
        if (this.m_sessionInfo != null) {
            this.m_sessionInfo.logoff();
            this.m_sessionInfo = null;
        }
        this.m_webAppPrefs = null;
        this.m_settings = null;
    }

    private VWStepProcessorInfo fetchDefaultStepProcessor() {
        try {
            VWStepProcessorInfo[] defaultStepProcessors = this.m_sessionInfo.getSession().fetchStepProcessors(2);
            if (defaultStepProcessors != null) {
                for (int i = 0; i < defaultStepProcessors.length; ++i) {
                    if (!defaultStepProcessors[i].isDefaultType() || !this.verifyProcessorInfo(defaultStepProcessors[i])) continue;
                    return defaultStepProcessors[i];
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private VWStepProcessorInfo fetchDefaultLaunchStepProcessor() {
        try {
            VWStepProcessorInfo[] defaultLaunchStepProcessors = this.m_sessionInfo.getSession().fetchStepProcessors(1);
            if (defaultLaunchStepProcessors != null) {
                for (int i = 0; i < defaultLaunchStepProcessors.length; ++i) {
                    if (!defaultLaunchStepProcessors[i].isDefaultType() || !this.verifyProcessorInfo(defaultLaunchStepProcessors[i])) continue;
                    return defaultLaunchStepProcessors[i];
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private boolean verifyProcessorInfo(VWStepProcessorInfo processorInfo) {
        try {
            if (processorInfo == null) {
                return false;
            }
            Hashtable locations = processorInfo.getLocations();
            if (locations == null || locations.isEmpty()) {
                return false;
            }
            if (processorInfo.getWidth() < 1) {
                return false;
            }
            if (processorInfo.getHeight() < 1) {
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private boolean launchApplication(String className, boolean bSingleton, String groupName) {
        try {
            if (this.m_sessionInfo == null) {
                return false;
            }
            if (className != null && className.length() > 0) {
                IVWAppLauncher appLauncher;
                Container parentContainer = this.m_sessionInfo.getParentContainer();
                className = className.trim();
                if (bSingleton && parentContainer instanceof IVWAppLauncher && (appLauncher = (IVWAppLauncher)((Object)parentContainer)).hasChildClass(className) && appLauncher.bringChildAppToFront(className)) {
                    return true;
                }
                ClassLoader loader = this.getClass().getClassLoader();
                Object childClass = loader.loadClass(className).newInstance();
                if (childClass != null) {
                    if (childClass instanceof IVWLaunchableApp) {
                        if (!this.m_sessionInfo.verifyLogon(groupName)) {
                            return false;
                        }
                        ((IVWLaunchableApp)childClass).init(this.m_sessionInfo);
                        if (parentContainer instanceof IVWAppLauncher) {
                            ((IVWAppLauncher)((Object)parentContainer)).registerApplication((IVWLaunchableApp)childClass);
                        }
                    }
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private VWOpenItemInfo getOpenItemInfo(VWStepProcessorInfo stepProcInfo, int nType) {
        try {
            if (this.m_webAppPrefs == null || this.m_settings == null) {
                this.initializeOpenItemInfo();
            }
            for (int nIndex = 0; nIndex < this.m_webAppPrefs.length; ++nIndex) {
                String location;
                VWOpenItemInfo itemInfo;
                Integer key = this.m_webAppPrefs[nIndex];
                if (key == null || (itemInfo = (VWOpenItemInfo)this.m_settings.get(key)) == null || !itemInfo.isValid(nType) || (location = stepProcInfo.getLocation(itemInfo.getWebAppId())) == null || location.length() <= 0) continue;
                return itemInfo;
            }
            Enumeration keys = this.m_settings.keys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    String location;
                    VWOpenItemInfo itemInfo = (VWOpenItemInfo)this.m_settings.get((Integer)keys.nextElement());
                    if (itemInfo == null || !itemInfo.isValid(nType) || (location = stepProcInfo.getLocation(itemInfo.getWebAppId())) == null || location.length() <= 0) continue;
                    return itemInfo;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void initializeOpenItemInfo() {
        try {
            if (this.m_webAppPrefs == null) {
                this.m_webAppPrefs = new Integer[4];
            }
            if (this.m_settings == null) {
                this.m_settings = new Hashtable();
            }
            if (!this.m_sessionInfo.verifyLogon(null)) {
                return;
            }
            VWUserInfo userInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                Object value = userInfo.getFieldValue("F_WebApp");
                this.setWebAppId(1, value);
            }
            this.initializeUsingAttributes(1);
            this.initializeUsingAttributes(2);
            Integer webAppId = new Integer(this.m_sessionInfo.getSession().getDefaultWebApplication());
            VWOpenItemInfo itemInfo = (VWOpenItemInfo)this.m_settings.get(webAppId);
            if (itemInfo != null) {
                String baseURL = VWHelp.getBaseURL(this.m_sessionInfo.getParentApplet());
                if (baseURL != null && baseURL.length() > 0) {
                    itemInfo.setBaseURL(baseURL);
                }
                this.setWebAppId(0, webAppId);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setWebAppId(int nIndex, Object value) {
        block8: {
            try {
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    String strValue = ((String)value).trim();
                    if (strValue.length() <= 0) break block8;
                    try {
                        int nWebAppId = Integer.parseInt(strValue);
                        if (nWebAppId != -1) {
                            this.m_webAppPrefs[nIndex] = new Integer(nWebAppId);
                        }
                        break block8;
                    }
                    catch (NumberFormatException ex) {}
                    break block8;
                }
                if (value instanceof Integer) {
                    this.m_webAppPrefs[nIndex] = (Integer)value;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void initializeUsingAttributes(int nType) {
        try {
            String[] names;
            VWAttributeInfo vwAttributeInfo = this.m_sessionInfo.getSession().fetchAttributes(nType);
            if (vwAttributeInfo != null && (names = vwAttributeInfo.getAttributeNames()) != null) {
                for (int nIndex = 0; nIndex < names.length; ++nIndex) {
                    String name = names[nIndex];
                    if (name.startsWith("F_WebApp")) {
                        if (nType == 2) {
                            this.setWebAppId(2, vwAttributeInfo.getFieldValue(name));
                            continue;
                        }
                        this.setWebAppId(3, vwAttributeInfo.getFieldValue(name));
                        continue;
                    }
                    VWOpenItemInfo itemInfo = null;
                    Integer webAppId = this.getIdFromKey(name);
                    if (webAppId == null) continue;
                    if (!this.m_settings.containsKey(webAppId)) {
                        itemInfo = new VWOpenItemInfo(webAppId);
                        this.m_settings.put(webAppId, itemInfo);
                    }
                    if ((itemInfo = (VWOpenItemInfo)this.m_settings.get(webAppId)) == null) continue;
                    if (name.startsWith("F_WebServer")) {
                        itemInfo.setBaseURL((String)vwAttributeInfo.getFieldValue(name));
                        continue;
                    }
                    if (name.startsWith("F_LSPTemplate")) {
                        itemInfo.setLspUrlTemplate((String)vwAttributeInfo.getFieldValue(name));
                        continue;
                    }
                    if (!name.startsWith("F_SPTemplate")) continue;
                    itemInfo.setSpUrlTemplate((String)vwAttributeInfo.getFieldValue(name));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Integer getIdFromKey(String key) {
        try {
            StringTokenizer st;
            if (key != null && key.length() > 0 && (st = new StringTokenizer(key, ".")).hasMoreTokens()) {
                String token = st.nextToken();
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    return Integer.valueOf(token);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

